﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Web.Security.AntiXss;

public partial class FragLabResultDetails : BasePage
{
    private const char MeasureSeparator = ' ';

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabResults.aspx",
        "/FragmentDetails.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly LabResultsManager _labResultsManager;
    private readonly LabOrderManager _labOrderManager;
    private readonly WorkflowCaseManager _activityManager;
    private readonly UserAccountManager _userAccountManager;

    private WKF_CASE_ACTIVITY _activity;
    private WKF_CASE_ACTIVITY _order;
    private WKF_CASE_ACTIVITY _labKit;
    private WKF_CASE _wCase;
    private STD_WKFACTIVITYST _activitySt;

    private int _wKFCaseActivityId;

    public FragLabResultDetails()
    {
        _labResultsManager = new LabResultsManager();
        _labOrderManager = new LabOrderManager();
        _activityManager = new WorkflowCaseManager();
        _userAccountManager = (UserAccountManager)HttpContext.Current.User;

        //Manager Save Notification Event Handler
        _labResultsManager.BOSaveSuccess += manager_BOSaveSuccess;
        _labOrderManager.BOSaveSuccess += manager_BOSaveSuccess;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
            _wKFCaseActivityId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["ActivityId"], false));
        else
            _wKFCaseActivityId = Convert.ToInt32(ViewState["ActivityId"]);

        if (!IsPostBack)
        {
            BindData(_wKFCaseActivityId, true);

            DisplayLabReportDetails();

            SetReferringPage();
        }

        //Only TEFSC ADMINISTRATOR or EFR_TEFSC_COORDINATOR can accept Lab Order Results.
        if (!_userAccountManager.GetRoles().Contains((int)RoleCode.EFR_TEFSC_ADMINISTRATOR)
            && !_userAccountManager.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR))
        {
            btnComplete.Enabled = false;
        }

        //Per Bug 612: Only TEFSC COORDINATOR can accept or reject Lab Order Results.
        if (!_userAccountManager.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR))
        {
            btnReject.Enabled = false;
        }
    }

    private void BindData(int wkfCaseActivityId, bool fullRefresh)
    {
        //boolean fullRefresh is added since deserialize is not persisting the analysismethod and fragment type values
        _wCase = _labResultsManager.GetLabResultDetails(wkfCaseActivityId);
        //TODO - Check the default value
        _activity = _wCase.WKF_CASE_ACTIVITies[0];
        ViewState["_wCase"] = _wCase.Serialize();
        ChangeHistoryUserControl.WorkFlowCalseId = _activity.WKF_CASE_ID.ToString();
        ChangeHistoryUserControl.ControlWidth = PanelPatient.Width;

        if (!IsPostBack)
        {
            _order = _labOrderManager.GetLabOrderByCaseId(_wCase.WKF_CASE_ID);
            ViewState["Order"] = _order.Serialize();
        }

        if (_order != null)
        {
            LabOrderLink.Visible = true;
            LabOrderLink.NavigateUrl = "FragLabOrder.aspx?activityId=" + _order.WKF_CASE_ACTIVITY_ID;

        }

        if (_activity != null)
        {
            if (fullRefresh == true)
            {
                lblFullName.Text = _activity.WKF_CASE.REFERRAL.PATIENT.FullName;
                lblICN.Text = _activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ICN;
                lblSnum.Text = _activity.WKF_CASE.REFERRAL.PATIENT.Snum;
                lblBirthday.Text = ConvertDateToString(_activity.WKF_CASE.REFERRAL.PATIENT.BIRTH_DATE);
                lblGender.Text = _activity.WKF_CASE.REFERRAL.PATIENT.STD_GENDER.NAME;
                lblZipCode.Text = _activity.WKF_CASE.REFERRAL.PATIENT.POSTAL_CODE;
                _activitySt = _activity.STD_WKFACTIVITYST;
                ViewState["OrderType"] = _activitySt.ID;
                ViewState["ActivityId"] = _activity.WKF_CASE_ACTIVITY_ID;
                ViewState["ActivityStName"] = _activitySt.NAME;
                if (_order != null && _order.LAB_ORDERs.Count() > 0)
                {
                    LabRptDate.DateValue = ConvertDateToString(_order.LAB_ORDERs.First().LAB_REPORT_DATE);

                    txtAccession.Text = _order.LAB_ORDERs.First().BSO_NUMBER;

                    txtLabID.Text = _order.LAB_ORDERs.First().LAB_ID_NUMBER;


                    txtLabCd.Text = _order.LAB_ORDERs.First().METALS_LAB_CODE;

                    FragProdEventDate.DateValue = ConvertDateToString(_order.LAB_ORDERs.First().FRAGMENT_PROD_EVENT_DATE);
                }
                if (_activitySt.ID == Convert.ToInt16(WorkflowCaseActivityStatus.New))
                {
                    btnComplete.Visible = false;
                    btnReject.Visible = true;
                    BtnSave.Text = "Save";

                    if (_activity.FRAGMENT_ANALYSIs.Count() == 0)
                    {
                        BtnSave.Enabled = false;
                        btnReject.Enabled = false;

                    }

                }
                else if (_activitySt.ID == Convert.ToInt16(WorkflowCaseActivityStatus.InProcess))
                {
                    btnComplete.Visible = true;
                    btnReject.Visible = true;
                    BtnSave.Text = "Save";
                }
                else if (_activitySt.ID == Convert.ToInt16(WorkflowCaseActivityStatus.Accepted))
                {
                    btnReject.Enabled = false;
                    BtnSave.Text = "Save";
                    CreateFragment.Visible = false;
                    BtnSave.Enabled = false;
                    btnComplete.Enabled = false;
                }
                else if (_activitySt.ID == Convert.ToInt16(WorkflowCaseActivityStatus.Voided))
                {
                    btnReject.Visible = false;
                    BtnSave.Text = "Un-Void";

                }
                Helpers.UnacceptLabResults(_activitySt.ID, _activity.WKF_CASE_ID, btnComplete, _userAccountManager);
            }


            _labKit = _activityManager.SelectByActivityType(_wCase.WKF_CASE_ID, "LabKit");
            if (_labKit != null)
            {
                var kitReceivedDate = _labKit.RECEIVED_DATE.HasValue ? AntiXssEncoder.HtmlEncode(_labKit.RECEIVED_DATE.Value.ToString("d"), false) : string.Empty;
                lblKitReceivedDate.Text = kitReceivedDate;
                KitReceivedDateHiddenBox.Text = kitReceivedDate;
            }
            BreadCrumbLabel.Text = AntiXssEncoder.HtmlEncode("My Tasks > Lab Results > " + ViewState["ActivityStName"].ToString() + " > Workflow ID " + _wCase.WKF_CASE_ID, false);

        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        Deserialize();
        _activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);
        SaveResultData(_order.LAB_ORDERs.First());
        HightlightMenu();

        OpenCloseReferralAndWorkflowCase(_wCase, () => "Save");
        SuppressSaveSuccessMessage = true;
        _labOrderManager.Update(_order);

        SuppressSaveSuccessMessage = false;
        _labResultsManager.UpdateResultActivity(_wCase);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        BindData(_activity.WKF_CASE_ACTIVITY_ID, true);
        ClientScriptManager cs = Page.ClientScript;
    }


    private void HightlightMenu()
    {
        //Highlight the corresponding menu item
        //BreadCrumbLabel.Text = "Lab Results > In Process";
        Menu Mnu = (Menu)Master.FindControl("MenuLeftNavigation");
        bool Selected;
        MenuBuilder.SelectAndHighLightElement(Mnu.Items, "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess), out Selected);
    }


    protected void CreateFragment_Click(object sender, EventArgs e)
    {
        Deserialize();

        SaveSessionLabReportDetails();
        Response.Redirect("FragmentDetails.aspx?activityId={0}", _activity.WKF_CASE_ACTIVITY_ID);

    }

    private void SaveSessionLabReportDetails()
    {
        if (!string.IsNullOrEmpty(LabRptDate.DateValue))
            Session["LabRptDate"] = SessionItemFactory.Create(LabRptDate.DateValue);

        if (!string.IsNullOrEmpty(txtAccession.Text))
            Session["Accession"] = SessionItemFactory.Create(txtAccession.Text);

        if (!string.IsNullOrEmpty(txtLabID.Text))
            Session["LabId"] = SessionItemFactory.Create(txtLabID.Text);

        if (!string.IsNullOrEmpty(txtLabCd.Text))
            Session["LabCode"] = SessionItemFactory.Create(txtLabCd.Text);

        if (!string.IsNullOrEmpty(FragProdEventDate.DateValue))
            Session["EventDate"] = SessionItemFactory.Create(FragProdEventDate.DateValue);
    }

    private void DisplayLabReportDetails()
    {
        var sessionValue = SessionItemValue.Get(Session["LabRptDate"]);
        if (sessionValue != null)
        {
            LabRptDate.DateValue = sessionValue.ToString();
            Session.Remove("LabRptDate");
        }

        sessionValue = SessionItemValue.Get(Session["Accession"]);
        if (sessionValue != null)
        {
            txtAccession.Text = sessionValue.ToString();
            Session.Remove("Accession");
        }

        sessionValue = SessionItemValue.Get(Session["LabId"]);
        if (sessionValue != null)
        {
            txtLabID.Text = sessionValue.ToString();
            Session.Remove("LabId");
        }

        sessionValue = SessionItemValue.Get(Session["LabCode"]);
        if (sessionValue != null)
        {
            txtLabCd.Text = sessionValue.ToString();
            Session.Remove("LabCode");
        }

        sessionValue = SessionItemValue.Get(Session["EventDate"]);
        if (sessionValue != null)
        {
            FragProdEventDate.DateValue = sessionValue.ToString();
            Session.Remove("EventDate");
        }
    }

    protected void btnReject_Click(object sender, EventArgs e)
    {
        //JH 8/11/2010: Per Bug 611: Modifying section to not delete result and place activity into new status but move to voided

        Deserialize();
        //Change the activity status to Voided
        _activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Voided);
        OpenCloseReferralAndWorkflowCase(_wCase, () => "Void");
        //PrepareFragmentData();
        SaveResultData(_order.LAB_ORDERs.First());

        SuppressSaveSuccessMessage = true;
        _labOrderManager.Update(_order);

        SuppressSaveSuccessMessage = false;
        _labResultsManager.UpdateResultActivity(_wCase);

        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        BindData(_activity.WKF_CASE_ACTIVITY_ID, true);
    }

    /// <summary>
    /// Database update when "Unaccept" button is clicked.
    /// </summary>
    private void UnacceptButtonClick()
    {
        WorkflowCaseManager wfcManager = new WorkflowCaseManager();

        Deserialize();

        OpenCloseReferralAndWorkflowCase(_wCase, () => "Save");

        Helpers.UnacceptLabResults(_activity, _wCase);

        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        Response.Redirect("LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess));
    }

    protected void btnComplete_Click(object sender, EventArgs e)
    {
        if (btnComplete.Text == "Unaccept")
        {
            UnacceptButtonClick();
        }
        else
        {
            Deserialize();
            _wCase.SetAsChangeTrackingRoot(true);
            _activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Accepted);
            //Used for Auto save
            SaveResultData(_order.LAB_ORDERs.First());

            foreach (var fragment in _activity.FRAGMENT_ANALYSIs)
            {
                fragment.RESULT_ACKNOWLEDGE_FLAG = true;
            }
            //Insert a new activity for Interpretation if it doesn't exist
            if (Helpers.GetInterpretationLetterWorkcaseActivity(_wCase.WKF_CASE_ID,
                   (int)WorkflowCaseManager.WorkFlowCaseActivityType.InterpretationDiagnosis) == null)
            {
                WKF_CASE_ACTIVITY InterpreTationActivity = _labResultsManager.CreateNewInterpretationActivity(_wCase.WKF_CASE_ID);
                _wCase.WKF_CASE_ACTIVITies.Add(InterpreTationActivity);
                InterpreTationActivity.SetAsInsertOnSubmit();
            }

            OpenCloseReferralAndWorkflowCase(_wCase, () => "Receive");
            _labResultsManager.UpdateResultActivity(_wCase);

            _order.SetAsChangeTrackingRoot();
            _order.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.Closed;
            _order.LAB_ORDERs.First().LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRptDate.DateValue.Trim());
            _order.LAB_ORDERs.First().RESULT_ACKNOWLEDGE_DATE = DateTime.Today;

            _labOrderManager.Update(_order);

            var master = this.Master as RegistryMaster;
            if (master != null)
            {
                master.SetDirtyFlag(false);
            }
            BindData(_activity.WKF_CASE_ACTIVITY_ID, true);
        }
    }

    private void SaveResultData(LAB_ORDER _order)
    {
        _order.SetAsChangeTrackingRoot(true);
        _order.LAB_REPORT_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRptDate.DateValue);
        _order.BSO_NUMBER = txtAccession.Text;
        _order.LAB_ID_NUMBER = txtLabID.Text;
        _order.METALS_LAB_CODE = txtLabCd.Text;

        _order.FRAGMENT_PROD_EVENT_DATE = Helpers.ConvertStringToNullable<DateTime>(FragProdEventDate.DateValue);

    }
    private string[] GetMeasurement(string dbVal)
    {
        if (dbVal == null) dbVal = "";
        return dbVal.Split(new Char[] { MeasureSeparator });
    }

    public void Fragments_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            Deserialize();

            SaveSessionLabReportDetails();
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRFragments.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRFragments.SelectedValue);
            Response.Redirect("FragmentDetails.aspx?activityId={0}&fragmentId={1}", _activity.WKF_CASE_ACTIVITY_ID, id);

        }
    }

    private void Deserialize()
    {

        _wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["_wCase"]);
        _order = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>((string)ViewState["Order"]);


        _activity = _wCase.WKF_CASE_ACTIVITies[0];
        _activity.SetAsChangeTrackingRoot(true);
    }

    private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
    {
        ReferralManager rm = new ReferralManager();

        EFR_REFERRAL parentReferral = rm.getReferralByReferralID(parentCase.REFERRAL_ID.Value);

        parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
        parentReferral.SetAsChangeTrackingRoot();

        if (operation() == "Void")
        {
            var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

            if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)

                parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;

            parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
        }
        else
        {
            if (parentReferral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;

            if (parentCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;

        }

        SuppressSaveSuccessMessage = true;
        rm.Update(parentReferral);

        SuppressSaveSuccessMessage = false;
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabResults";
    }

    public override string AppObjectCode()
    {
        return "LabResults";
    }
}
